/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.charta.game;

import dev.lucaargolo.charta.Charta;
import dev.lucaargolo.charta.game.Card;
import dev.lucaargolo.charta.game.CardDeck;
import dev.lucaargolo.charta.game.CardGame;
import dev.lucaargolo.charta.game.CardPlay;
import dev.lucaargolo.charta.game.CardPlayer;
import dev.lucaargolo.charta.utils.CardPlayerHead;
import java.util.LinkedList;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.class_1767;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;

public class AutoPlayer
implements CardPlayer {
    private final Random random = new Random();
    private final LinkedList<Card> hand = new LinkedList();
    private CompletableFuture<CardPlay> play = new CompletableFuture();
    private int playAge = 0;
    protected final float intelligence;

    public AutoPlayer(float intelligence) {
        this.intelligence = intelligence;
    }

    @Override
    public LinkedList<Card> hand() {
        return this.hand;
    }

    @Override
    public void play(CardPlay play) {
        this.play.complete(play);
    }

    @Override
    public void afterPlay(Consumer<CardPlay> consumer) {
        this.play.thenAccept(play -> {
            try {
                consumer.accept((CardPlay)play);
            }
            catch (Exception e) {
                Charta.LOGGER.error("Error while handling {}'s Card Play. ", (Object)this.getName().getString(), (Object)e);
            }
        });
    }

    @Override
    public void resetPlay() {
        this.play = new CompletableFuture();
        this.playAge = 0;
    }

    @Override
    public void tick(CardGame<?> game) {
        if (game.getCurrentPlayer() == this && !this.play.isDone()) {
            int threshold = (int)class_3532.method_16439((float)this.intelligence, (float)50.0f, (float)20.0f);
            if (this.playAge > (threshold += this.random.nextInt(-5, 40))) {
                CardPlay cardPlay = game.getBestPlay(this);
                this.play(cardPlay);
            } else {
                ++this.playAge;
            }
        }
    }

    @Override
    public void openScreen(CardGame<?> game, class_2338 pos, CardDeck deck) {
    }

    @Override
    public void sendMessage(class_2561 message) {
    }

    @Override
    public void sendTitle(class_2561 title, @Nullable class_2561 subtitle) {
    }

    @Override
    public class_2561 getName() {
        return class_2561.method_43470((String)"AutoPlayer");
    }

    @Override
    public class_1767 getColor() {
        return class_1767.field_7952;
    }

    @Override
    public int getId() {
        return -1;
    }

    @Override
    public CardPlayerHead getHead() {
        return CardPlayerHead.ROBOT;
    }

    @Override
    public boolean shouldCompute() {
        return true;
    }
}

